﻿<%@ Page Title="Registries and Cohorts" Language="C#" MasterPageFile="~/Site.Master" AutoEventWireup="true" CodeBehind="Registry.aspx.cs" Inherits="VIRP_WEB.Cohorts.Registry" %>

<%@ Register Src="~/Controls/AdminUser.ascx" TagPrefix="uc" TagName="AdminUser" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <asp:Label ID="lblPageTitle" runat="server" Text="Registries and Cohorts" Font-Size="X-Large" />
    <br /><br />
    <asp:Label ID="lblResult" runat="server" ForeColor="Red" />

    <asp:Panel ID="pnlRegistries" runat="server">
        <asp:Label ID="lblSearchFilter" runat="server" Text="Search By" AssociatedControlID="ddlSearch" />&nbsp;&nbsp;
        <asp:DropDownList ID="ddlSearch" runat="server" ToolTip="Select to filter column view results" AutoPostBack="false">
            <asp:ListItem Text="Name" Value="NAME"></asp:ListItem>
            <asp:ListItem Text="Abbreviation" Value="CODE"></asp:ListItem>
            <asp:ListItem Text="Description Text" Value="DESCRIPTION_TEXT"></asp:ListItem>
        </asp:DropDownList>
        <asp:Label ID="lblSearchText" runat="server" Text="Search Text" AssociatedControlID="txtSearch" style="display:none;" />
        <asp:TextBox runat="server" ID="txtSearch" Width="120px"></asp:TextBox>
        <asp:Button runat="server" ID="btnSearch" OnClick="BtnSearch_Click" Text="Search" ToolTip="Select to begin search" />
        <asp:Button runat="server" ID="btnClear" OnClick="BtnClear_Click" Text="Clear" ToolTip="Select to clear search" />
        <br /><br />
        <asp:GridView ID="gridRegistry" runat="server" CssClass="gridWizard" PagerStyle-CssClass="pager" EmptyDataRowStyle-CssClass="gridRegistryEmpty"
            EmptyDataText="Currently no existing Registries are available" DataSourceID="dsRegistry" Caption="VIRP Registries"
            AutoGenerateColumns="false" AllowPaging="true" AllowSorting="true" PageSize="10">
            <Columns>
                <asp:TemplateField SortExpression="ID" ItemStyle-Width="100">
                    <ItemTemplate>
                        <asp:LinkButton ID="linkEdit" runat="server" Text="Edit" OnClick="LinkEdit_Click" CommandArgument='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("ID")) %>' ToolTip="Select to edit registry information" />
                        &nbsp;|&nbsp;
                        <asp:LinkButton ID="linkDelete" runat="server" Text="Delete" OnClick="LinkDelete_Click" CommandArgument='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("ID")) + ";" + VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("Code")) %>' ToolTip="Select to delete registry" OnClientClick='return confirm("Are you sure you want to delete this Registry?");' />
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderStyle-ForeColor="White" SortExpression="NAME" AccessibleHeaderText="Name" HeaderText="Name" ItemStyle-Width="200">
                    <ItemTemplate>
                        <asp:LinkButton ID="linkName" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("NAME")) %>' CommandArgument='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("ID")) %>' OnClick="LinkName_Click" ToolTip="Select to edit extended information for this registry" />
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:BoundField HeaderStyle-ForeColor="White" SortExpression="CODE" AccessibleHeaderText="Abbreviation" HeaderText="Abbreviation" DataField="CODE" ItemStyle-Width="50" />
                <asp:BoundField HeaderStyle-ForeColor="White" SortExpression="DESCRIPTION_TEXT" AccessibleHeaderText="Description" HeaderText="Description" DataField="DESCRIPTION_TEXT" />
            </Columns>
        </asp:GridView>
        <asp:ObjectDataSource ID="dsRegistry" runat="server" TypeName="VIRP_WEB.BaseCode.ServiceInterfaceManager" SelectMethod="STD_REGISTRY_GET_ALL_BY_USER" OnSelecting="Ds_Selecting" SortParameterName="SORT_EXPRESSION" />

        <br />
        <asp:LinkButton ID="linkRegistryAdd" runat="server" Text="Add New Registry" OnClick="LinkRegistryAdd_Click" ToolTip="Select to add a new registry" />
        <br /><br />
    </asp:Panel>

    <asp:Panel ID="pnlRegistry" runat="server">
        <asp:Label ID="lblRegistryResult" runat="server" ForeColor="Red" />

        <asp:UpdatePanel ID="UpdatePanel1" runat="server">
            <ContentTemplate>

                <asp:LinkButton ID="linkRegistry" runat="server" Text="Registry Info" ToolTip="Select to manage basic registry information" style="padding:4px; border:1px solid white;" OnClick="LinkRegistry_Click" />&nbsp;
                <asp:LinkButton ID="linkContact" runat="server" Text="Contact Info" ToolTip="Select to manage registry contact information" style="padding:4px; border:1px solid white;" OnClick="LinkContact_Click" />&nbsp;
                <asp:LinkButton ID="linkSchedule" runat="server" Text="Schedule Info" ToolTip="Select to manage registry schedule information" style="padding:4px; border:1px solid white;" OnClick="LinkSchedule_Click" />
                <asp:LinkButton ID="LinkMiscellaneous" runat="server" Text="Miscellaneous Info" ToolTip="Select to manage registry miscellaneous information" style="padding:4px; border:1px solid white;" OnClick="LinkMiscellaneous_Click" />
                <br /><br />

                <asp:Panel ID="pnlRegistryContainer" runat="server" style="padding:4px; border:1px solid white;">
                    <asp:HiddenField ID="hideRegistryId" runat="server" />
                    <asp:Table ID="tblRegistryInfo" runat="server">
                        <asp:TableRow>
                            <asp:TableCell><asp:Label ID="lblRegistryName" runat="server" Text="Registry Name (required field)" AssociatedControlID="txtRegistryName" />&nbsp;&nbsp;</asp:TableCell>
                            <asp:TableCell><asp:TextBox ID="txtRegistryName" runat="server" MaxLength="100" Width="400" ToolTip="Enter a value for Registry Name" /></asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow><asp:TableCell ColumnSpan="2">&nbsp;</asp:TableCell></asp:TableRow>
                        <asp:TableRow>
                            <asp:TableCell><asp:Label ID="lblRegistryCode" runat="server" Text="Abbreviation (required field)" AssociatedControlID="txtRegistryCode" />&nbsp;&nbsp;</asp:TableCell>
                            <asp:TableCell><asp:TextBox ID="txtRegistryCode" runat="server" MaxLength="50" Width="400" ToolTip="Enter a value for Registry Abbreviation" /></asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow><asp:TableCell ColumnSpan="2">&nbsp;</asp:TableCell></asp:TableRow>
                        <asp:TableRow>
                            <asp:TableCell><asp:Label ID="lblRegistryDescription" runat="server" Text="Description (required field)" AssociatedControlID="txtRegistryDescription" />&nbsp;&nbsp;</asp:TableCell>
                            <asp:TableCell><asp:TextBox ID="txtRegistryDescription" runat="server" MaxLength="500" Width="400" TextMode="MultiLine" Rows="5" ToolTip="Enter a value for Registry Description" /></asp:TableCell>
                        </asp:TableRow>
                    </asp:Table>
                </asp:Panel>
                <asp:Panel ID="pnlContactContainer" runat="server" style="padding:4px; border:1px solid white;">
                    <asp:Table ID="tblContactInfo" runat="server">
                        <asp:TableRow>
                            <asp:TableCell><asp:Label ID="lblRegistryOwner" runat="server" Text="Registry Owner" AssociatedControlID="listRegistryOwner" />&nbsp;&nbsp;</asp:TableCell>
                            <asp:TableCell>
                                    <asp:DropDownList ID="listRegistryOwner" runat="server" ToolTip="Select a value for Registry Owner" DataValueField="USER_ID" DataTextField="FULL_NAME" />&nbsp;&nbsp;
                                    <asp:Button ID="btnAddUser1" runat="server" Text="New User" OnClick="BtnAddUser_Click" ToolTip="Select to create a new user" />
                            </asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow><asp:TableCell ColumnSpan="2">&nbsp;</asp:TableCell></asp:TableRow>
                        <asp:TableRow>
                            <asp:TableCell><asp:Label ID="lblRegistryAdministrator" runat="server" Text="Registry Administrator" AssociatedControlID="listRegistryAdministrator" />&nbsp;&nbsp;</asp:TableCell>
                            <asp:TableCell>
                                    <asp:DropDownList ID="listRegistryAdministrator" runat="server" ToolTip="Select a value for Registry Administrator" DataValueField="USER_ID" DataTextField="FULL_NAME" />&nbsp;&nbsp;
                                    <asp:Button ID="btnAddUser2" runat="server" Text="New User" OnClick="BtnAddUser_Click" ToolTip="Select to create a new user" />
                            </asp:TableCell>
                        </asp:TableRow>
                        <asp:TableRow><asp:TableCell ColumnSpan="2">&nbsp;</asp:TableCell></asp:TableRow>
                        <asp:TableRow>
                            <asp:TableCell><asp:Label ID="lblSupportContact" runat="server" Text="Support Contact" AssociatedControlID="listSupportContact" />&nbsp;&nbsp;</asp:TableCell>
                            <asp:TableCell>
                                    <asp:DropDownList ID="listSupportContact" runat="server" ToolTip="Select a value for Registry Support Contact" DataValueField="USER_ID" DataTextField="FULL_NAME" />&nbsp;&nbsp;
                                    <asp:Button ID="btnAddUser3" runat="server" Text="New User" OnClick="BtnAddUser_Click" ToolTip="Select to create a new user" />
                            </asp:TableCell>
                        </asp:TableRow>
                    </asp:Table>
                </asp:Panel>
                <asp:Panel ID="pnlScheduleContainer" runat="server" style="padding:4px; border:1px solid white;">
                    <asp:Label ID="lblScheduleManual" runat="server" Text="Update schedule for manually added referrals" AssociatedControlID="rblScheduleManual" />
                    <br />
                    <asp:RadioButtonList ID="rblScheduleManual" runat="server" ToolTip="Set a schedule for manually added referrals">
                        <asp:ListItem Value="0" Text="No Schedule" />
                        <asp:ListItem Value="1" Text="Daily" />
                        <asp:ListItem Value="2" Text="Weekly" />
                    </asp:RadioButtonList>
                    <br /><br />

                    <asp:Label ID="lblScheduleAuto" runat="server" Text="Update schedule for automatically added referrals" AssociatedControlID="rblScheduleAuto" />
                    <br />
                    <asp:RadioButtonList ID="rblScheduleAuto" runat="server" OnSelectedIndexChanged="RblScheduleAuto_SelectedIndexChanged" AutoPostBack="true" ToolTip="Set a schedule for manually added referrals">
                        <asp:ListItem Value="0" Text="No Schedule" />
                        <asp:ListItem Value="1" Text="Daily" />
                        <asp:ListItem Value="2" Text="Weekly" />
                    </asp:RadioButtonList>
                    <br />

                    <asp:Label ID="lblScheduleAutoTime" runat="server" Text="Scheduled Time" AssociatedControlID="listScheduleAutoTime" />
                    &nbsp;&nbsp;
                    <asp:DropDownList ID="listScheduleAutoTime" runat="server" ToolTip="Set a preferred time for data loads and updates">
                        <asp:ListItem Value="0" Text="No Preference" />
                        <asp:ListItem Value="1" Text="1:00 AM" />
                        <asp:ListItem Value="2" Text="2:00 AM" />
                        <asp:ListItem Value="3" Text="3:00 AM" />
                        <asp:ListItem Value="4" Text="4:00 AM" />
                        <asp:ListItem Value="5" Text="5:00 AM" />
                    </asp:DropDownList>
                </asp:Panel>
                <asp:Panel ID="pnlMiscellaneousContainer" runat="server" style="padding:4px; border:1px solid white;">
                    <asp:CheckBox ID="chkbxAllowSurveys" runat="server" ToolTip="Select to allow surveys to be submitted as a text note to CPRS" text="Allow surveys to be submitted as a text note to CPRS"/>
                </asp:Panel>

            </ContentTemplate>
        </asp:UpdatePanel>

        <asp:UpdateProgress ID="UpdateProgress1" AssociatedUpdatePanelID="UpdatePanel1" runat="server" DisplayAfter="0"> 
        <ProgressTemplate> 
            <div id="modalDiv" class="delayModalStyle" style="position:fixed; height:100%; width: 100%; top:0; left:0; z-index: 100;"> 
            &nbsp; 
            </div>
            <div id="delayIndicatorDiv" class="delayIndicatorStyle" style="position:fixed; top:50%; left:40%; z-index:1003;"> 
                <img alt="" src="../Images/ajax-loader.gif" />
                Processing request. Please wait.
            </div> 
        </ProgressTemplate> 
        </asp:UpdateProgress>

        <br />

        <asp:Table ID="tblSaveForm" runat="server" Width="500">
            <asp:TableRow>
                <asp:TableCell Width="25%">
                    <asp:Button ID="btnBack" runat="server" Text="Back" ToolTip="Select to save and go back" OnClick="BtnBack_Click" />
                </asp:TableCell>
                <asp:TableCell Width="50%" HorizontalAlign="Center">
                    <asp:Button ID="btnSave" runat="server" Text="Save" OnClick="BtnSave_Click" ToolTip="Select to save all registry values" />
                    &nbsp;&nbsp;
                    <asp:Button ID="btnCancel" runat="server" Text="Return to List" OnClick="BtnCancel_Click" ToolTip="Select to cancel changes and return to registry list" />
                </asp:TableCell>
                <asp:TableCell Width="25%" HorizontalAlign="Right">
                    <asp:Button ID="btnNext" runat="server" Text="Next" ToolTip="Select to save and continue" OnClick="BtnNext_Click" />
                </asp:TableCell>
            </asp:TableRow>
        </asp:Table>
    </asp:Panel>

    <asp:Panel ID="pnlAddUser" runat="server" CssClass="modalPopup" style="display:none;" Width="1000px">
        <div class="modalPopupTitle">&nbsp;&nbsp;<asp:Label ID="lblAddUser" runat="server" Text="Add New User" /></div>
        <br />
        <asp:Label ID="lblAddUserResult" runat="server" ForeColor="Red" />
        <uc:AdminUser ID="AdminUser" runat="server" 
            OnSearchClicked="AdminUser_SearchClicked" OnSearchCancelClicked="AdminUser_SearchCancelClicked" 
            OnSaveClicked="AdminUser_SaveClicked" OnCancelClicked="AdminUser_CancelClicked" OnSaveRolesClicked="AdminUser_SaveRolesClicked" />
    </asp:Panel>

    <asp:Button ID="btnHideShow" runat="server" style="display:none;" />
    <asp:Button ID="btnHideCancel" runat="server" style="display:none;" />

    <ajax:ModalPopupExtender ID="mpeAddUser" runat="server" 
        BackgroundCssClass="modalBackground" CancelControlID="btnHideCancel" PopupControlID="pnlAddUser" TargetControlID="btnHideShow"  />
</asp:Content>
